#!/bin/sh
# wrapper-install.sh
# POSIX-compliant wrapper to run the makeself installer and install JSON file

# Hardcoded paths
INSTALLER="install_uls-ultra-embedded-pc_16.3.902_internal.sh"
JSON_FILE="MotionPlanningConfigOverride.json"
DEST_DIR="/etc/opt/uls-control"
DEST_JSON="$DEST_DIR/MotionPlanningConfigOverride.json"

# Exit immediately on error
set -eu

# Make sure installer exists
if [ ! -f "$INSTALLER" ]; then
    echo "Error: Installer not found: $INSTALLER" >&2
    exit 1
fi

# Make installer executable if needed
if [ ! -x "$INSTALLER" ]; then
    echo "Making installer executable..."
    chmod +x "./$INSTALLER"
fi

# Run the installer from current directory
echo "Running installer: $INSTALLER"
"./$INSTALLER"

# Ensure target directory exists and copy JSON file
echo "Installing JSON to $DEST_JSON"
sudo mkdir -p "$DEST_DIR"
sudo cp "$JSON_FILE" "$DEST_JSON"
sudo chmod 644 "$DEST_JSON"
sudo chown root:root "$DEST_JSON"

echo "Done."

